﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Wizdom365.BLL.IoC;
using Wizdom365.BLL.Managers;

namespace GUI.Web.Base.Bundles
{
    public partial class Redirect : System.Web.UI.Page
    {
        private readonly WizdomLicenseManager _licenseManager;
        private readonly IFeatureToggleManager _featureToggleManager;

        public Redirect() : this(Ioc.Resolve<WizdomLicenseManager>(), Ioc.Resolve<IFeatureToggleManager>())
        {
        }

        public Redirect(WizdomLicenseManager licenseManager, IFeatureToggleManager featureToggleManager)
        {
            _licenseManager = licenseManager;
            _featureToggleManager = featureToggleManager;
        }
        protected void Page_Load(object sender, EventArgs e)
        {
            //redirTo=wizdomsuccess
            string sTo = Request.QueryString["redirTo"];
            if (sTo.ToLower() == "wizdomsuccess")
            {


                if (_featureToggleManager.IsActive("UserSpecificSuccessCenter"))
                {
#if ONPREM
                var relativeUrl = "/wp-autologin_new.php";
                var license = _licenseManager.GetWizdomLicenseInformation();
                var company = license.CompanyName;
                var hash = _licenseManager.ComputeMD5Hash();
                var loginName = HttpContext.Current.User.Identity.Name.Split('\\').Last();//remove backslash from login name
                relativeUrl += string.Format("{0}company={1}&key={2}&user={3}", relativeUrl.IndexOf("?") > 0 ? "&" : "?", HttpUtility.UrlEncode(company), HttpUtility.UrlEncode(hash), HttpUtility.UrlEncode(loginName));

                Response.Redirect("https://support.livetilesglobal.com/hc/en-us/categories/360002157411-Intranet-Enterprise");
#endif
#if AZURE
                    Response.Redirect("https://support.livetilesglobal.com/hc/en-us/categories/360002157411-Intranet-Enterprise");
#endif
                }
                else
                {
                    var relativeUrl = "/wp-autologin.php";
                    var license = _licenseManager.GetWizdomLicenseInformation();
                    var company = license.CompanyName;
                    var hash = _licenseManager.ComputeMD5Hash();
                    relativeUrl += string.Format("{0}company={1}&key={2}", relativeUrl.IndexOf("?") > 0 ? "&" : "?", HttpUtility.UrlEncode(company), HttpUtility.UrlEncode(hash));
                    Response.Redirect("https://support.livetilesglobal.com/hc/en-us/categories/360002157411-Intranet-Enterprise");
                }
            }
        }
    }
}